package mcfall.raytracer.objects;

import java.util.List;

import mcfall.math.ColumnVector;
import mcfall.math.Point;
import mcfall.math.Ray;
import mcfall.math.Vector;

/**
 * This class represents the generic circle, which is a circle with radius 1 in the XY plane (that is, all points have a z coordinate of 0)
 * This class extends genericSquare so that optimizations are 
 * @author mcfall
 *
 */
public class GenericCircle extends GenericSquare {

	public GenericCircle () {
		super ();
	}
	
	/**
	 * Constructs a GenericCircle object with the given name
	 * @param name the name to associate with this object
	 */
	public GenericCircle(String name) {
		super(name);
	}
	
	@Override
	protected List<HitRecord> genericHitTime(Ray ray) {
		return new java.util.ArrayList<HitRecord> ();
	}

	@Override
	protected String getObjectType() {
		return ("Generic Circle");
	}

}
